#pragma GCC optimize("Ofast,unroll-loops")
#pragma GCC target("avx2,bmi,bmi2,popcnt,lzcnt")

#include <iostream>
#include <vector>
#include <numeric>
#include <algorithm>
#include <random>

using namespace std;

using ll = long long;

int main()
{
    cin.tie(0)->sync_with_stdio(0);
    int n, m;
    cin >> n >> m;
    vector<vector<int>> adj(n + 1), adj2(n + 1);
    vector<int> in(n + 1), out(n + 1);
    while (m--)
    {
        int a, b;
        cin >> a >> b;
        adj[a].push_back(b);
        ++in[b];
        ++out[a];
    }
    vector<int> nin(n + 1);
    bool all = true;
    for (int i = 1; i <= n; ++i)
    {
        if (in[i] == 0 || out[i] == 0)
        {
            cout << "NO";
            return 0;
        }
        if (in[i] != 1 || out[i] != 1) all = false;
        if (adj[i].size() == 1)
        {
            adj2[i] = adj[i];
            ++nin[adj[i].front()];
        }
    }
    if (all)
    {
        mt19937 gen(79723);
        for (int i = 1; i <= n; ++i)
        {
            shuffle(adj[i].begin(), adj[i].end(), gen);
            if (in[i] == 0 || out[i] == 0)
            {
                cout << "NO\n";
                return 0;
            }
        }
        vector<int> res;
        res.reserve(1e6);
        vector<bool> used(n + 1);
        int cnt = 0, sum = 0;
        auto dfs = [&res, &used, &adj, &cnt, &n, &sum](auto self, int v) -> void
        {
            used[v] = true;
            ++cnt;
            for (int u : adj[v])
            {
                ++sum;
                /*if (sum >= 3e7)
                 {
                 cout << "NO\n";
                 exit(0);
                 }*/
                if (u == 1 && cnt == n)
                {
                    res.push_back(1);
                    res.push_back(v);
                    return;
                }
                if (!used[u])
                {
                    self(self, u);
                    if (!res.empty())
                    {
                        res.push_back(v);
                        return;
                    }
                }
            }
            --cnt;
            used[v] = false;
        };
        dfs(dfs, 1);
        if (res.empty()) cout << "NO\n";
        else
        {
            cout << "YES\n";
            reverse(res.begin(), res.end());
            for (int i : res) cout << i << ' ';
        }
    }
    vector<vector<int>> paths;
    vector<int> where(n + 1, -1);
    auto dfs = [&adj2, &where, &paths](auto self, int v) -> void
    {
        where[v] = (int)paths.size() - 1;
        paths.back().push_back(v);
        if (!adj2[v].empty()) self(self, adj2[v].front());
    };
    for (int i = 1; i <= n; ++i)
    {
        if (nin[i] == 0)
        {
            paths.push_back(vector<int>());
            dfs(dfs, i);
        }
    }
    for (int i = 1; i <= n; ++i)
    {
        if (where[i] == -1)
        {
            cout << "NO\n";
            return 0;
        }
    }
    vector<vector<int>> nadj(paths.size());
    for (int i = 0; i < paths.size(); ++i)
    {
        for (int u : adj[paths[i].back()])
        {
            if (paths[where[u]].front() == u)
            {
                nadj[i].push_back(where[u]);
            }
        }
    }
    vector<int> res;
    res.reserve(25);
    vector<bool> used(nadj.size());
    int cnt = 0;
    auto dfs2 = [&res, &used, &nadj, &cnt, n = nadj.size()](auto self, int v) -> void
    {
        used[v] = true;
        ++cnt;
        for (int u : nadj[v])
        {
            if (u == 0 && cnt == n)
            {
                res.push_back(v);
                return;
            }
            if (!used[u])
            {
                self(self, u);
                if (!res.empty())
                {
                    res.push_back(v);
                    return;
                }
            }
        }
        --cnt;
        used[v] = false;
    };
    dfs2(dfs2, 0);
    if (res.empty())
    {
        cout << "NO";
        return 0;
    }
    cout << "YES\n";
    vector<int> nres;
    for (int i : res)
    {
        for (int u : paths[i]) nres.push_back(u);
    }
    int f1 = int(find(nres.begin(), nres.end(), 1) - nres.begin());
    for (int i = f1; i < nres.size(); ++i) cout << nres[i] << ' ';
    for (int i = 0; i <= f1; ++i) cout << nres[i] << ' ';
    return 0;
}
